<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Insert data into Google Sheet
 *
 * @since 1.2.0
 * @param $content string The results page content from filter
 * @uses MLWQuizMasterNext:pluginHelper
 * @return string The modified content to send back to filter
 */
function qsm_addon_google_sheet_connect( $content, $options, $quiz_results ) {
	//Load settings

	global $mlwQuizMasterNext;
	global $wpdb;
	// Gets results data.
	$result_id		 = $quiz_results['result_id'];
	$results_data	 = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$wpdb->prefix}mlw_results WHERE result_id = %d", $result_id ) );
	if ( is_serialized( $results_data->quiz_results ) && is_array( @unserialize( $results_data->quiz_results ) ) ) {
		$results = unserialize( $results_data->quiz_results );
	}

	$gs_conn = get_option( 'gs_accesscode', '' );
	if ( empty( $gs_conn ) ) {
		return $content;
	}

	// Load the settings
	$gs_connector_data	 = $mlwQuizMasterNext->pluginHelper->get_quiz_setting( "gs_connector_quiz_integration_settings" );
	$gs_defaults		 = array(
		'gs_name'				 => '',
		'gs_tab_name'			 => '',
		'gs_save_only_contact'	 => 'no',
		'gs_save_custom_contact' => '',
		'gs_question_comment' => '',
		'gs_individual_question_score' => '',
	);
	$gs_connector_data	 = wp_parse_args( $gs_connector_data, $gs_defaults );
	$data				 = array();
	$header_arr			 = array();
	if ( ( ! empty( $gs_connector_data['gs_name'] ) ) && ( ! empty( $gs_connector_data['gs_tab_name'] ) ) ) {
		include_once( dirname( __FILE__ ) . "/google-apiclient/quickstart.php" );
		$doc = new QSM_Google_Sheets( $gs_connector_data['gs_name'], $gs_connector_data['gs_tab_name'] );

		// $question_answer = $quiz_results['question_answers_array'];
		$question_answer = $results[1];
		$form_type		 = isset( $quiz_results['form_type'] ) ? $quiz_results['form_type'] : 0;
		$quiz_system	 = isset( $quiz_results['quiz_system'] ) ? $quiz_results['quiz_system'] : 0;
		if ( is_user_logged_in() ) {
			$userObj = wp_get_current_user();
			if ( empty( $quiz_results['user_name'] ) || $quiz_results['user_name'] == 'None' ) {
				$quiz_results['user_name'] = $userObj->user_login;
			}
			if ( empty( $quiz_results['user_email'] ) || $quiz_results['user_email'] == 'None' ) {
				$quiz_results['user_email'] = $userObj->user_email;
			}
		}
		$header_arr				 = array(
			'Timestamp'	 => date_i18n( "Y-m-d H:i:s" ),
		);
		$custom_contact_array	 = array();
		if ( ! empty( $results['contact'] ) ) {
			foreach ( $results['contact'] as $contact ) {
				if ( ! empty( $contact['use'] ) ) {
					$custom_contact_array[$contact['label']] = html_entity_decode( $contact['value'] );
				} else {
					if ( $gs_connector_data['gs_save_custom_contact'] == 'on' ) {
						$custom_contact_array[$contact['label']] = html_entity_decode( $contact['value'] );
					}
				}
			}
		}
		
		// inserting custom contact field in required position
		if ( ! empty( $custom_contact_array ) ) {
			$header_arr = array_merge( $header_arr, $custom_contact_array );
		}
		// Add IP Address
		$header_arr['ip'] = $quiz_results['user_ip'];
		/**
		 * Save only Contact fields.
		 */
		if ( isset( $gs_connector_data['gs_save_only_contact'] ) && $gs_connector_data['gs_save_only_contact'] == 'yes' ) {
			$header_arr = apply_filters( 'qsm_google_sheet_header_array', $header_arr, $content, $options, $quiz_results );
			$doc->add_row( $header_arr, $header_arr, $results );
			return $content;
		}

		$header_arr['Total Correct']	 = $quiz_results['total_correct'];
		$header_arr['Total Questions']	 = $quiz_results['total_questions'];
		$header_arr['Score']			 = $quiz_results['total_score'];
		$header_arr['Quiz Comments']			 = $quiz_results['comments'];
		if ( $form_type == 0 ) {
			if ( $quiz_system == 1 ) {
				$header_arr['Score'] = $quiz_results['total_points'];
			} else if ( $quiz_system == 3 ) {
				$header_arr['Points'] = $quiz_results['total_points'];
			}
		}
		$i					 = 1;
		$questions_titles	 = array();
		$header_arr			 = apply_filters( 'qsm_google_sheet_header_array', $header_arr, $content, $options, $quiz_results );
		$data				 = $header_arr;

		foreach ( $question_answer as $key => $question_answer_single ) {
			$question_title			 = isset( $question_answer_single[0] ) ? $question_answer_single[0] : '';
			$check_question_title	 = strtolower( str_replace( ' ', '', $question_title ) );
			if ( isset( $question_answer_single['question_title'] ) && '' != $question_answer_single['question_title'] ) {
				$question_title			 = $question_answer_single['question_title'];
				$_scores				 = get_question_title( $questions_titles, $question_title );
				$check_question_title	 = strtolower( str_replace( ' ', '', $question_title ) ) . $_scores;
			}
			if ( array_key_exists( $check_question_title, $data ) ) {
				$data[$check_question_title . $i]	 	= $question_answer_single[1];
				$header_arr[$question_title . $i]	 	= $question_answer_single[1];

				if ( $gs_connector_data['gs_question_comment'] == 'on' ) {
					$data["Question ". $i ." Comment"]	 	= $question_answer_single[3];				
					$header_arr["Question ". $i ." Comment"]= $question_answer_single[3];
				}

				if ( $gs_connector_data['gs_individual_question_score'] == 'on' ) {
					if ( $question_answer_single['correct'] == 'correct' ) {
						$data["Question ". $i ." Points Earned"]		= $question_answer_single['points'];				
						$header_arr["Question ". $i ." Points Earned"]	= $question_answer_single['points'];
					} else {
						$data["Question ". $i ." Points Earned"]		= 0;				
						$header_arr["Question ". $i ." Points Earned"]	= 0;
					}					
				}

				$questions_titles[]					 	= $question_title . $_scores . $i;
				$i++;
			} else {
				$data[$check_question_title] 			= $question_answer_single[1];
				$header_arr[$question_title] 			= $question_answer_single[1];

				if ( $gs_connector_data['gs_question_comment'] == 'on' ) {
					$data["Question ". $i ." Comment"]	 	= $question_answer_single[3];				
					$header_arr["Question ". $i ." Comment"]= $question_answer_single[3];
				}

				if ( $gs_connector_data['gs_individual_question_score'] == 'on' ) {
					if ( $question_answer_single['correct'] == 'correct' ) {
						$data["Question ". $i ." Points Earned"]		= $question_answer_single['points'];				
						$header_arr["Question ". $i ." Points Earned"]	= $question_answer_single['points'];
					} else {
						$data["Question ". $i ." Points Earned"]		= 0;				
						$header_arr["Question ". $i ." Points Earned"]	= 0;
					}					
				}

				$questions_titles[]			 			= $question_title . $_scores;
				$i++;
			}
		}
		// Add Parameters in Google Sheet
		if ( isset( $quiz_results['parameters'] ) && is_array( $quiz_results['parameters'] ) ) {
			$parameters = $quiz_results['parameters'];
			foreach ( $parameters as $param_name => $param_val ) {
				$data[strtolower( str_replace( ' ', '', $param_name ) )] = $param_val;
				$header_arr[$param_name]								 = $param_val;
			}
		}
		
		$doc->add_row( $data, $header_arr, $results );
	}
	return $content;
}

function get_question_title( $questions_titles, $question_title ) {
	$_scores	 = "";
	$repeat		 = 0;
	$included	 = false;
	for ( $i = 0; $i < count( $questions_titles ); $i ++ ) {
		$q_title = ($i == 0) ? $question_title : $question_title . str_repeat( "_", $i );
		if ( in_array( $q_title, $questions_titles ) ) {
			$included = true;
			$repeat ++;
			continue;
		}
		if ( $included )
			return str_repeat( "_", $repeat );
	}
	return $_scores;
}
