<?php
if (!defined('ABSPATH')) {
	exit;
}

/**
 * Registers your tab in the quiz settings page
 *
 * @since 1.2.0
 * @return void
 */
function qsm_addon_qs_connector_register_quiz_settings_tabs() {
	global $mlwQuizMasterNext;
	if (!is_null($mlwQuizMasterNext) && !is_null($mlwQuizMasterNext->pluginHelper) && method_exists($mlwQuizMasterNext->pluginHelper, 'register_quiz_settings_tabs')) {
		$mlwQuizMasterNext->pluginHelper->register_quiz_settings_tabs("Google Sheets", 'qsm_addon_gs_connector_quiz_settings_tabs_content');
	}
}

/**
 * Generates the content for your quiz settings tab
 *
 * @since 1.2.0
 * @return void
 */
function qsm_addon_gs_connector_quiz_settings_tabs_content() {

	global $mlwQuizMasterNext;
	$date_now = date("d-m-Y");
	wp_enqueue_script( 'qsm_google-sheet_js', QSM_GOOGLE_SHEET_URL.'/qsm-google-sheet.js', array( 'jquery' ), '2.1.4', true );
	$settings	 = get_option('qsm_addon_gs_connector_settings', '');
	$license		 = isset( $settings['license_key'] ) ? trim( $settings['license_key'] ) : '';
	$license_status	 = isset( $settings['license_status'] ) ? $settings['license_status'] : '';
	if( '' != $license && 'valid' == $license_status ) {
		if ( version_compare( $mlwQuizMasterNext->version, '8.1.6', '>' ) && (isset($settings['expiry_date']) && "" != $settings['expiry_date']) && (isset($settings['last_validate']) && "" != $settings['last_validate']) && strtotime($date_now) > strtotime($settings['expiry_date']) && strtotime($date_now) >= strtotime($settings['last_validate']) ) { 
			$item_url = 'https://quizandsurveymaster.com/checkout/?edd_license_key='.$license.'&download_id='.GOOGLE_SHEET_ITEM;
			$target_text =  __('License Key Expired. ', 'qsm-google-sheets');
			$target_link = sprintf( $target_text.'<a style="font-weight: 500;" href="%s" target="_blank">%s</a>', esc_url( $item_url ), __( 'Click here to renew', 'qsm-google-sheets' ) );
			$mlwQuizMasterNext->alertManager->newAlert( $target_link, 'error' );
		}
	//If nonce is set and correct, save the form
	if (isset($_POST["gs_connector_quiz_integration_nonce"]) && wp_verify_nonce($_POST['gs_connector_quiz_integration_nonce'], 'gs_connector_quiz_integration')) {
		$google_sheet_data = array(
			'gs_name' => sanitize_text_field($_POST["gs_name"]),
			'gs_tab_name' => sanitize_text_field($_POST["gs_tab_name"]),
			'gs_save_only_contact' => sanitize_text_field($_POST["gs_save_only_contact"]),
			'gs_save_custom_contact' => isset($_POST["gs_save_custom_contact"])?sanitize_text_field($_POST["gs_save_custom_contact"]):'',
			'gs_question_comment' => isset($_POST["gs_question_comment"])?sanitize_text_field($_POST["gs_question_comment"]):'',
			'gs_individual_question_score' => isset($_POST["gs_individual_question_score"])?sanitize_text_field($_POST["gs_individual_question_score"]):'',
		);
		$mlwQuizMasterNext->pluginHelper->update_quiz_setting("gs_connector_quiz_integration_settings", $google_sheet_data);
		$mlwQuizMasterNext->alertManager->newAlert(__('Your google sheet settings has been saved successfully!','qsm-google-sheets'), 'success');
	}

	// Load the settings
	$gs_conn_data = $mlwQuizMasterNext->pluginHelper->get_quiz_setting("gs_connector_quiz_integration_settings");
	$gs_conn_defaults = array(
		'gs_name' => '',
		'gs_tab_name' => '',
		'gs_save_only_contact' => 'no',
	);
	$google_sheet_data = wp_parse_args($gs_conn_data, $gs_conn_defaults);
	?>
<div class="qsm-alerts">
	<?php $mlwQuizMasterNext->alertManager->showAlerts(); ?>
</div>
<div id="tabs-gsc-integration" class="mlw_tab_content">
	<h2><?php _e('Google Sheet Settings','qsm-google-sheets'); ?></h2>
	<form action="" method="post">
		<button class="button-primary"><?php _e('Save Settings','qsm-google-sheets'); ?></button>
		<table class="form-table" style="width: 100%;">
			<tr valign="top">
				<th scope="row">
					<label for="gs_name"><?php _e('Google Sheet ID','qsm-google-sheets'); ?></label>
				</th>
				<td>
					<input type="text" name="gs_name" id="gs_name" value="<?php echo $google_sheet_data["gs_name"]; ?>">
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label for="gs_name"><?php _e('Google Sheet Tab Name','qsm-google-sheets'); ?></label>
				</th>
				<td>
					<input type="text" name="gs_tab_name" id="gs_tab_name"
						value="<?php echo $google_sheet_data["gs_tab_name"]; ?>">
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label><?php _e('Save only contact information','qsm-google-sheets'); ?></label>
				</th>
				<td>
					<?php
						$save_only_contact = isset($google_sheet_data["gs_save_only_contact"]) ? $google_sheet_data["gs_save_only_contact"] : 'no';
						?>
					<label>
						<input type="radio" name="gs_save_only_contact" id="gs_save_only_contact_yes" value="yes"
							<?php echo ($save_only_contact == 'yes') ? 'checked="checked"' : ''; ?>>
						<span><?php _e('Yes','qsm-google-sheets'); ?></span>
					</label>
					<label>
						<input type="radio" name="gs_save_only_contact" id="gs_save_only_contact_no" value="no"
							<?php echo ($save_only_contact != 'yes') ? 'checked="checked"' : ''; ?>>
						<span><?php _e('No','qsm-google-sheets'); ?></span>
					</label>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label><?php _e('Save custom contact fields','qsm-google-sheets'); ?></label>
				</th>
				<td>
					<?php
						$save_custom_contact = isset($google_sheet_data["gs_save_custom_contact"]) ? $google_sheet_data["gs_save_custom_contact"] : '';
						?>
					<label>
						<input type="checkbox" name="gs_save_custom_contact" id="gs_save_custom_contact_yes" value="on"
							<?php echo ($save_custom_contact == 'on') ? 'checked="checked"' : ''; ?>>
					</label>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label><?php _e("Save question's comment",'qsm-google-sheets'); ?></label>
				</th>
				<td>
					<?php
						$question_comment = isset($google_sheet_data["gs_question_comment"]) ? $google_sheet_data["gs_question_comment"] : '';
						?>
					<label>
						<input type="checkbox" name="gs_question_comment" id="gs_question_comment_yes" value="on"
							<?php echo ($question_comment == 'on') ? 'checked="checked"' : ''; ?>>
					</label>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<label><?php _e("Individual question score",'qsm-google-sheets'); ?></label>
				</th>
				<td>
					<?php
						$individual_question_score = isset($google_sheet_data["gs_individual_question_score"]) ? $google_sheet_data["gs_individual_question_score"] : '';
						?>
					<label>
						<input type="checkbox" name="gs_individual_question_score" id="gs_individual_question_score_yes" value="on"
							<?php echo ($individual_question_score == 'on') ? 'checked="checked"' : ''; ?>>
					</label>
				</td>
			</tr>
		</table>
		<?php wp_nonce_field('gs_connector_quiz_integration', 'gs_connector_quiz_integration_nonce'); ?>
		<button class="button-primary"><?php _e('Save Settings','qsm-google-sheets'); ?></button>
	</form>
</div>
<?php
	}else{
		$params		 = array(
			'please_wait'    => __('Please Wait...', 'qsm-google-sheets'),
			'license_msg'    => __('License Key Required.', 'qsm-google-sheets'),
		);
		wp_localize_script( 'qsm_google-sheet_js', 'qsm_google_sheet_obj', $params );
		$mlwQuizMasterNext->alertManager->showAlerts();?>
		<div class="license_form_parent">
			<div id="license_message" style="display: none;" class="error below-h2"><p><strong class="qsm_google_sheet_validate_message"></strong></div>
			<h4><strong><?php esc_html_e( 'Please validate your licence key. ', 'qsm-google-sheets' ); ?></strong></h4>
			<div class="qsm_google_sheet_validate_parent">
				<form class="rq_validata-license" method="POST">
					<input type="text" placeholder="<?php echo esc_html("Enter your license key"); ?>" class="qsm_google_sheet_validate_input" name="qsm_google_sheet_validate_input" />
					<input type="submit" name="qsm_google_sheet_validate_button" class="qsm_google_sheet_validate_button button button-primary" />
				</form>
			</div>
		</div>
		<?php
	}
}